#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from AddOneDivision import AddOneDivision
from AddHCSDivision import AddHCSDivision

# Create Divisions

def AddDivisions(VistA,state,institutionpointer):
  AddHCSDivision(VistA, state + ' VA HEALTHCARE SYSTEM' ,institutionpointer  ,'1')
  AddOneDivision(VistA, state + ' VA MEDICAL CENTER'    ,'1',institutionpointer +'MC')
  AddOneDivision(VistA, state + ' VA OUTPATIENT CLINC'  ,'1',institutionpointer +'OC')

def AddDivisionsByConfig(VistA, divJson):
  for division in divJson:
    print division
    if "MultiDivision" in division:
      AddHCSDivision(VistA, division['Name'], division['Facility Number'], '1')
    else:
      AddOneDivision(VistA, division['Name'], division['Outpatient Only'], division['Facility Number'])
